﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml.Linq;

namespace SWAT_Office_App
{
    public partial class Settings_Form : Form
    {
        // Global static variables
        private static string settingsLogLocation = "Settings.xml";
        public static string globalAdminPassword = "tr33b3@rd";
        public static bool defaultSettings { get; set; }
        public static bool showFileSizes { get; set; }
        public static List<string> systemAccounts = new List<string>();
        public static List<string> hiddenAccounts = new List<string>();
        public static string sharedFolderLocation { get; set; }
        public static string usbMasterx32CopyLocation { get; set; }
        public static string usbMasterx64CopyLocation { get; set; }
        
        // Static variables for use by DriveLogger
        public static int driveLoggerRefreshInterval { get; set; }
        public static List<string> driveLoggerDockLabels = new List<string>();
        public static List<string> driveLoggerDrivesToIgnore = new List<string>();

        private static Settings_Form _Settings_Form = null;
        // Singleton instance so the settings file isnt loaded every time
        public static Settings_Form settings_Form_Instance
        {
            set
            {
                _Settings_Form = value;
            }
            get
            {
                if (_Settings_Form == null)
                    _Settings_Form = new Settings_Form();
                return _Settings_Form;
            }
        }
        public Settings_Form()
        {
            ImportSettings();
            InitializeComponent();
            
            this.listBox_SystemAccounts.SelectedIndexChanged += new EventHandler(this.listBox_SystemAccounts_SelectedIndexChanged);
            this.listBox_HiddenAccounts.SelectedIndexChanged += new EventHandler(this.listBox_HiddenAccounts_SelectedIndexChanged);
            this.Load += new EventHandler(Settings_Form_Load);
        }
        private void Settings_Form_Load(object sender, EventArgs e)
        {
            OpenUpdateSettings();
            settings_Form_Instance.btn_SystemRemove.Enabled = false;
        }
        public void listBox_SystemAccounts_SelectedIndexChanged(object sender, EventArgs e)
        {
            settings_Form_Instance.btn_SystemRemove.Enabled = true;
        }
        public void listBox_HiddenAccounts_SelectedIndexChanged(object sender, EventArgs e)
        {
            settings_Form_Instance.btn_HiddenRemove.Enabled = true;
        }
        public static void ImportSettings()
        {
            // Imports settings from Settings.xml
            try
            {
                if (File.Exists(settingsLogLocation))
                {
                    // XML Parsing using System.XML.Linq
                    XElement Settings = XElement.Load(settingsLogLocation);

                    showFileSizes = bool.Parse(Settings.Element("ProgramSettings").Element("ShowFileSizes").Value);

                    systemAccounts.Clear();
                    string tempSystemAccounts = Settings.Element("ProgramSettings").Element("SystemAccounts").Value;
                    string[] tempStringArray = tempSystemAccounts.Split(new char[] { ',' });
                    foreach (string str in tempStringArray)
                        systemAccounts.Add(str.Trim());

                    hiddenAccounts.Clear();
                    string tempHiddenAccounts = Settings.Element("ProgramSettings").Element("HiddenAccounts").Value;
                    tempStringArray = tempHiddenAccounts.Split(new char[] { ',' });
                    foreach (string str in tempStringArray)
                        hiddenAccounts.Add(str.Trim());

                    driveLoggerDockLabels.Clear();
                    string tempDriveLoggerDockLabels = Settings.Element("ProgramSettings").Element("DockLabels").Value;
                    tempStringArray = tempDriveLoggerDockLabels.Split(new char[] { ',' });
                    foreach (string str in tempStringArray)
                        driveLoggerDockLabels.Add(str.Trim());

                    driveLoggerRefreshInterval = int.Parse(Settings.Element("ProgramSettings").Element("DockRefreshInterval").Value);

                    driveLoggerDrivesToIgnore.Clear();
                    string tempDrivesToIgnore = Settings.Element("ProgramSettings").Element("DockDrivesToIgnore").Value;
                    tempStringArray = tempDrivesToIgnore.Split(new char[] { ',' });
                    foreach (string str in tempStringArray)
                        driveLoggerDrivesToIgnore.Add(str.Trim());

                    sharedFolderLocation = Settings.Element("ProgramSettings").Element("SharedFolderLocation").Value;
                    usbMasterx32CopyLocation = Settings.Element("ProgramSettings").Element("USBMasterCopyx32Location").Value;
                    usbMasterx64CopyLocation = Settings.Element("ProgramSettings").Element("USBMasterCopyx64Location").Value;
                    Debug.appendText("Settings from " + settingsLogLocation + " has been imported");
                }
                else
                {
                    MessageBox.Show("No existing setting file detected. Using default settings");
                    Debug.appendText("No existing setting file detected. Using default settings");
                    WriteDefaultConfigFile();
                }
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
        private static void OpenUpdateSettings()
        {
            // Update the buttons on the form with the imported settings
            settings_Form_Instance.txt_ShareLocation.Text = sharedFolderLocation;
            settings_Form_Instance.txt_USBMasterCopyLocation_x32.Text = usbMasterx32CopyLocation;
            settings_Form_Instance.txt_USBMasterCopyLocation_x64.Text = usbMasterx64CopyLocation;
            PaintListBox();
        }
        private static void ExitUpdateSettings()
        {
            // Update the static variables from the form
            sharedFolderLocation = settings_Form_Instance.txt_ShareLocation.Text;
            usbMasterx32CopyLocation = settings_Form_Instance.txt_USBMasterCopyLocation_x32.Text;
            usbMasterx64CopyLocation = settings_Form_Instance.txt_USBMasterCopyLocation_x64.Text;
        }
        private static void ExportSettings()
        {
            // Exports all settings to Settings.xml
            try
            {
                // XML Parsing using System.XML.Linq
                XElement Settings = XElement.Load(settingsLogLocation);

                string tempString = "";
                foreach (string str in systemAccounts)
                    tempString = tempString.Insert(tempString.Length, str + ',');
                if (tempString.Length > 0)
                    tempString = tempString.Remove(tempString.Length - 1, 1);
                Settings.Element("ProgramSettings").SetElementValue("SystemAccounts", tempString);

                tempString = "";
                foreach (string str in hiddenAccounts)
                    tempString = tempString.Insert(tempString.Length, str + ',');
                if (tempString.Length > 0)
                    tempString = tempString.Remove(tempString.Length - 1, 1);
                Settings.Element("ProgramSettings").SetElementValue("HiddenAccounts", tempString);

                Settings.Element("ProgramSettings").SetElementValue("SharedFolderLocation", sharedFolderLocation);
                Settings.Element("ProgramSettings").SetElementValue("USBMasterCopyx32Location", usbMasterx32CopyLocation);
                Settings.Element("ProgramSettings").SetElementValue("USBMasterCopyx64Location", usbMasterx64CopyLocation);

                Settings.Save("Settings.xml");
                Debug.appendText("Settings has been exported to " + settingsLogLocation);
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
        private static void WriteDefaultConfigFile()
        {
            // Writes the default settings configuration
            try
            {
                XElement Settings = new XElement("Settings",
                    new XElement("ProgramSettings",
                        new XElement("ShowFileSizes","true"),
                        new XElement("SystemAccounts", "Administrators,Administrator"),
                        new XElement("HiddenAccounts", "Administrator,Guest"),
                        new XElement("SharedFolderLocation", "C:\\"),
                        new XElement("USBMasterCopyx32Location", "C:\\"),
                        new XElement("USBMasterCopyx64Location", "C:\\"),
                        new XElement("DockLabels", "Dock 1,Dock 2,Dock 3,External USB"),
                        new XElement("DockRefreshInterval", 1000),
                        new XElement("DockDrivesToIgnore", "C:\\")
                        )
                    );
                Settings.Save(settingsLogLocation);
                Debug.appendText("A default settings file has been created");
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
        private static void PaintListBox()
        {
            // Paints & Refreshes the listbox of system and hidden accounts
            settings_Form_Instance.listBox_SystemAccounts.Items.Clear();
            foreach (string user in systemAccounts)
                settings_Form_Instance.listBox_SystemAccounts.Items.Add(user);
            settings_Form_Instance.listBox_HiddenAccounts.Items.Clear();
            foreach (string user in hiddenAccounts)
                settings_Form_Instance.listBox_HiddenAccounts.Items.Add(user);
        }
        private void btn_Ok_Click(object sender, EventArgs e)
        {
            ExitUpdateSettings();
            ExportSettings();
            this.Close();
        }
        private void btn_Cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        private void btn_Default_Click(object sender, EventArgs e)
        {
            // Resets settings to default settings
            try
            {
                if (MessageBox.Show("Reset configurations to the default settings?", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
                {
                    File.Delete(settingsLogLocation);
                    WriteDefaultConfigFile();
                    ImportSettings();
                    OpenUpdateSettings();
                }
            }
            catch (Exception ex)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(ex.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
        private void btn_SystemAdd_Click(object sender, EventArgs e)
        {
            Add_System_Account_Form newForm = new Add_System_Account_Form();
            newForm.ShowDialog();
            PaintListBox();
        }
        private void btn_SystemRemove_Click(object sender, EventArgs e)
        {
            systemAccounts.Remove(this.listBox_SystemAccounts.SelectedItem.ToString());
            PaintListBox();
        }
        private void btn_HiddenAdd_Click(object sender, EventArgs e)
        {
            Add_Hidden_Account_Form newForm = new Add_Hidden_Account_Form();
            newForm.ShowDialog();
            PaintListBox();
        }
        private void btn_HiddenRemove_Click(object sender, EventArgs e)
        {
            hiddenAccounts.Remove(this.listBox_HiddenAccounts.SelectedItem.ToString());
            PaintListBox();
        }
        private void btn_ShareLocationChange_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
            {
                this.txt_ShareLocation.Text = folderBrowserDialog.SelectedPath;
                sharedFolderLocation = folderBrowserDialog.SelectedPath;
            }
        }
        private void btn_USBLocationx32Change_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
            {
                this.txt_USBMasterCopyLocation_x32.Text = folderBrowserDialog.SelectedPath;
                usbMasterx32CopyLocation = folderBrowserDialog.SelectedPath;
            }
        }
        private void btn_USBLocationx64Change_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog.ShowDialog() == DialogResult.OK)
            {
                this.txt_USBMasterCopyLocation_x64.Text = folderBrowserDialog.SelectedPath;
                usbMasterx64CopyLocation = folderBrowserDialog.SelectedPath;
            }
        }
    }
}
